﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
//using DG.Tweening;

public class FirstLevelTrigger : MonoBehaviour
{
    private bool m_bControl = true;
    private List<MeshRenderer> m_lst = new List<MeshRenderer>();
    private void OnTriggerEnter(Collider other)
    {
        if (other.gameObject.CompareTag("Target"))
        {
            StorageView varView = BattleCtrl.instance.levelManager.curLevel.storageView;
            MeshRenderer varMesh = other.GetComponent<MeshRenderer>();
            if (varMesh &&!m_lst.Contains(varMesh))
            {
                varView.InsideBox(other);
                m_lst.Add(varMesh);
            }
        }
    }
    private void OnTriggerExit(Collider other)
    {
        if (other.gameObject.CompareTag("Target"))
        {
            StorageView varView = BattleCtrl.instance.levelManager.curLevel.storageView;
            MeshRenderer varMesh = other.GetComponent<MeshRenderer>();
            if (varMesh && m_lst.Contains(varMesh))
            {
                varView.ExitBox();
                m_lst.Remove(varMesh);
            }
        }
    }
}
